//--------------
// un-tweaks
//--------------
   float4x4 WorldVP:WorldViewProjection;
   float4x4 World:World;   
   float4x4 ViewInv:ViewInverse; 
 
//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
	float3 Normal:NORMAL;
  	float3 Color:COLOR0;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float4 Color:COLOR0;
     };
 
//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=mul(IN.Pos,WorldVP);
 	OUT.Color=float4(IN.Color,0.75);
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
     {
	return IN.Color;
     }

//--------------
// techniques   
//--------------
   technique Widget
      {
 	pass p0
      {
	vertexShader = compile vs_3_0 VS();
 	pixelShader  = compile ps_3_0 PS();
	AlphaBlendEnable=true;
	zwriteenable=false;
      }
      }